#!/usr/bin/env python3

from subprocess import Popen, STDOUT, PIPE
from pathlib import Path

files = open("zips.txt").read().split("\n")
files = [ Path(f).resolve() for f in files if f ]

for f in files:
    newname = "".join(f.name.split(".")[:-1]) + ".7z"
    print(f"running: 7z a {newname} {f}")
    system = Popen(["7z", "a", str(f)], stderr=STDOUT, stdout=PIPE)
    print(system.communicate())

